CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'pdv_vd_cpl_crm_bonus') THEN 
        CREATE TABLE pdv_vd_cpl_crm_bonus (
            cd_emp bigint not null default 0,
            cd_filial bigint not null default 0,
            cd_vd bigint not null default 0,
			cd_cx int not null default 0,
            cgc_cpf varchar(20) null default '',
            nome_cliente varchar(500) null default '',
            email_cli varchar(200) null default '',
			celular_cli varchar(25) null default '',
			dt_nasc_cli varchar(10) null default '',
			user_id_cliente varchar(300) null default '',
            utilizou_pin_master int not null default 0,
			id_campanha bigint not null default 0,
			CONSTRAINT pdv_vd_cpl_crm_bonus_pkey PRIMARY KEY (cd_emp, cd_filial, cd_vd, cd_cx)
        )
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA pdv_vd_cpl_crm_bonus %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();